<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attachment extends Model 
{

    protected $table = 'attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->morphedByMany('User', 'attachmentable');
    }

    public function specializations()
    {
        return $this->morphedByMany('Specialization', 'attachmentable');
    }

}